import { StyleSheet } from "react-native";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";

const PhotoGalleryStyle = () =>
    StyleSheet.create({
        cont: {
            width: dpr('wf'),
            alignItems:'center',
            marginBottom: dpr(15)
        },
        closeIcon: {
            position: "absolute",
            right: dpr(15),
            top: dpr(35),
            zIndex: 999,
            padding: 10,
        },
        modalCont: {
            width: dpr("wf"),
        },
        footerCont: {
            width: dpr("wf"),
            flexGrow: 1,
            justifyContent: "center",
            alignItems: "center",
        },
        footerImage: (image, index) => ({
            height: dpr(70),
            width: dpr(70),
            borderWidth: image == index ? 3 : 0,
            borderColor: image == index ? "#FCCA19" : "#000",
            marginRight: dpr(10),
            borderRadius: 6,
        }),
    });

export default PhotoGalleryStyle;
